import { useQuery } from "@tanstack/react-query";
import { api, buildUrl } from "@shared/routes";

// GET /api/salads
export function useSalads() {
  return useQuery({
    queryKey: [api.salads.list.path],
    queryFn: async () => {
      const res = await fetch(api.salads.list.path, { credentials: "include" });
      if (!res.ok) throw new Error("Failed to fetch menu");
      return api.salads.list.responses[200].parse(await res.json());
    },
  });
}

// GET /api/salads/:id
export function useSalad(id: number) {
  return useQuery({
    queryKey: [api.salads.get.path, id],
    enabled: !!id,
    queryFn: async () => {
      const url = buildUrl(api.salads.get.path, { id });
      const res = await fetch(url, { credentials: "include" });
      if (res.status === 404) return null;
      if (!res.ok) throw new Error("Failed to fetch salad details");
      return api.salads.get.responses[200].parse(await res.json());
    },
  });
}
