import { useQuery } from "@tanstack/react-query";
import { type Subscription } from "@shared/schema";

export function useSubscriptions() {
  return useQuery<Subscription[]>({
    queryKey: ["/api/subscriptions"],
  });
}

export function useSubscription(id: number) {
  return useQuery<Subscription>({
    queryKey: ["/api/subscriptions", id],
  });
}
