import { useI18n } from "@/lib/i18n";
import { Link } from "wouter";
import { motion } from "framer-motion";
import { ArrowRight, Leaf, Heart, Award } from "lucide-react";
import dattaMoreImg from "@assets/datu_more_1766311171725.jpeg";

export default function Home() {
  const { t, language } = useI18n();

  const container = {
    hidden: { opacity: 0 },
    show: {
      opacity: 1,
      transition: {
        staggerChildren: 0.1
      }
    }
  };

  const item = {
    hidden: { opacity: 0, y: 20 },
    show: { opacity: 1, y: 0 }
  };

  return (
    <div className="w-full">
      {/* Hero Section */}
      <section className="relative overflow-hidden bg-gradient-to-br from-green-50 to-orange-50 pt-16 pb-24 lg:pt-32 lg:pb-40">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
          <motion.div 
            variants={container}
            initial="hidden"
            animate="show"
            className="text-center max-w-4xl mx-auto"
          >
            <motion.div variants={item} className="inline-block mb-6">
              <span className="px-4 py-1.5 rounded-full bg-primary/10 text-primary font-bold text-sm uppercase tracking-wide border border-primary/20">
                100% Fresh & Healthy
              </span>
            </motion.div>
            
            <motion.h1 variants={item} className="text-5xl md:text-7xl font-display font-extrabold text-foreground mb-6 leading-tight">
              {t("hero.title")}
            </motion.h1>
            
            <motion.p variants={item} className="text-xl md:text-2xl text-muted-foreground mb-10 max-w-2xl mx-auto font-light">
              {t("hero.subtitle")}
            </motion.p>
            
            <motion.div variants={item} className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link href="/menu" className="inline-flex items-center justify-center px-8 py-4 text-lg font-bold rounded-full text-white bg-primary hover:bg-primary/90 shadow-lg shadow-primary/30 transition-all hover:-translate-y-1">
                {t("hero.cta")}
                <ArrowRight className="ml-2 w-5 h-5" />
              </Link>
              <Link href="/contact" className="inline-flex items-center justify-center px-8 py-4 text-lg font-bold rounded-full text-foreground bg-white border border-border hover:bg-secondary/30 transition-all">
                {t("nav.contact")}
              </Link>
            </motion.div>
          </motion.div>
        </div>
        
        {/* Background decorative elements */}
        <div className="absolute top-1/2 left-0 -translate-y-1/2 -translate-x-1/2 w-[500px] h-[500px] bg-primary/5 rounded-full blur-3xl -z-0"></div>
        <div className="absolute bottom-0 right-0 translate-y-1/4 translate-x-1/4 w-[600px] h-[600px] bg-accent/5 rounded-full blur-3xl -z-0"></div>
      </section>

      {/* Why Daily Bowl Section */}
      <section className="py-24 bg-white">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-display font-bold text-foreground mb-4">{t("why.title")}</h2>
            <div className="h-1.5 w-24 bg-accent mx-auto rounded-full"></div>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="group p-8 rounded-3xl bg-secondary/10 border border-secondary/20 hover:border-secondary hover:shadow-xl hover:shadow-secondary/10 transition-all duration-300">
              <div className="w-14 h-14 bg-green-100 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform">
                <Leaf className="w-7 h-7 text-green-600" />
              </div>
              <h3 className="text-xl font-bold mb-3">{t("why.fresh")}</h3>
              <p className="text-muted-foreground leading-relaxed">{t("why.fresh.desc")}</p>
            </div>

            <div className="group p-8 rounded-3xl bg-orange-50/50 border border-orange-100 hover:border-accent/30 hover:shadow-xl hover:shadow-accent/10 transition-all duration-300">
              <div className="w-14 h-14 bg-orange-100 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform">
                <Heart className="w-7 h-7 text-orange-600" />
              </div>
              <h3 className="text-xl font-bold mb-3">{t("why.health")}</h3>
              <p className="text-muted-foreground leading-relaxed">{t("why.health.desc")}</p>
            </div>

            <div className="group p-8 rounded-3xl bg-blue-50/50 border border-blue-100 hover:border-blue-200 hover:shadow-xl hover:shadow-blue-500/5 transition-all duration-300">
              <div className="w-14 h-14 bg-blue-100 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform">
                <Award className="w-7 h-7 text-blue-600" />
              </div>
              <h3 className="text-xl font-bold mb-3">{t("why.taste")}</h3>
              <p className="text-muted-foreground leading-relaxed">{t("why.taste.desc")}</p>
            </div>
          </div>
        </div>
      </section>

      {/* Brand Ambassador Section */}
      <section className="py-24 bg-foreground text-white relative overflow-hidden">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
          <div className="flex flex-col md:flex-row items-center gap-12 lg:gap-24">
            <div className="w-full md:w-1/2 flex justify-center">
              <div className="relative">
                <div className="absolute inset-0 bg-accent/20 rounded-full blur-3xl transform scale-110"></div>
                <div className="relative w-64 h-64 md:w-80 md:h-80 rounded-full border-4 border-accent overflow-hidden shadow-2xl">
                  <img src={dattaMoreImg} alt="Datta More" className="w-full h-full object-cover" />
                </div>
                <div className="absolute -bottom-6 -right-6 bg-accent text-white px-6 py-2 rounded-xl shadow-lg transform rotate-3">
                  <span className="font-display font-bold text-lg">Daily Bowl</span>
                </div>
              </div>
            </div>
            
            <div className="w-full md:w-1/2 text-center md:text-left">
              <span className="text-accent font-bold tracking-widest uppercase mb-2 block">{t("brand.endorsement")}</span>
              <h2 className="text-4xl md:text-5xl font-display font-bold mb-6">Datta More</h2>
              <p className="text-xl leading-relaxed mb-8 text-white/90">
                {language === 'en' 
                  ? "I trust Daily Bowl for my daily nutrition. It's the perfect blend of authentic Marathi taste and modern health requirements." 
                  : "माझ्या रोजच्या पोषणासाठी मी डेली बाउलवर विश्वास ठेवतो. हे अस्सल मराठी चव आणि आधुनिक आरोग्याच्या गरजा यांचा परिपूर्ण संगम आहे."}
              </p>
              <Link href="/menu" className="inline-block px-8 py-3 rounded-full border-2 border-white text-white hover:bg-white hover:text-foreground font-bold transition-all">
                {t("nav.menu")}
              </Link>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}
