import { z } from 'zod';
import { insertSaladSchema, insertSubscriptionSchema, insertComboSchema, insertContactRequestSchema, salads, subscriptions, combos, contactRequests } from './schema';

export const errorSchemas = {
  validation: z.object({
    message: z.string(),
    field: z.string().optional(),
  }),
  notFound: z.object({
    message: z.string(),
  }),
  internal: z.object({
    message: z.string(),
  }),
};

export const api = {
  salads: {
    list: {
      method: 'GET' as const,
      path: '/api/salads',
      responses: {
        200: z.array(z.custom<typeof salads.$inferSelect>()),
      },
    },
    get: {
      method: 'GET' as const,
      path: '/api/salads/:id',
      responses: {
        200: z.custom<typeof salads.$inferSelect>(),
        404: errorSchemas.notFound,
      },
    },
  },
  subscriptions: {
    list: {
      method: 'GET' as const,
      path: '/api/subscriptions',
      responses: {
        200: z.array(z.custom<typeof subscriptions.$inferSelect>()),
      },
    },
    get: {
      method: 'GET' as const,
      path: '/api/subscriptions/:id',
      responses: {
        200: z.custom<typeof subscriptions.$inferSelect>(),
        404: errorSchemas.notFound,
      },
    },
  },
  combos: {
    list: {
      method: 'GET' as const,
      path: '/api/combos',
      responses: {
        200: z.array(z.custom<typeof combos.$inferSelect>()),
      },
    },
    get: {
      method: 'GET' as const,
      path: '/api/combos/:id',
      responses: {
        200: z.custom<typeof combos.$inferSelect>(),
        404: errorSchemas.notFound,
      },
    },
  },
  contact: {
    submit: {
      method: 'POST' as const,
      path: '/api/contact',
      input: insertContactRequestSchema,
      responses: {
        201: z.custom<typeof contactRequests.$inferSelect>(),
        400: errorSchemas.validation,
      },
    },
  },
};

export function buildUrl(path: string, params?: Record<string, string | number>): string {
  let url = path;
  if (params) {
    Object.entries(params).forEach(([key, value]) => {
      if (url.includes(`:${key}`)) {
        url = url.replace(`:${key}`, String(value));
      }
    });
  }
  return url;
}
